<?php

/* Copyright 2021  KITA Toshihiro https://tkita.net/
 * License of this file : the Apache License version 2.0
 * https://www.apache.org/licenses/LICENSE-2.0
 */

// Token & Secret : see LINE Developers Console  https://developers.line.biz/console/
$channelAccessToken = 'tttttttttt';
$channelSecret = 'ssssssssssss';

const col_keyword  = 0;
const col_response = 1;

require_once(__DIR__ . '/LINEBotTinyKita.php');
require_once(__DIR__ . '/curl.php');

$client = new LINEBotTiny($channelAccessToken, $channelSecret);
$data = load_data();

foreach ($client->parseEvents() as $event) {
  $rtoken = $event['replyToken'];
  // file_put_contents("./temp/linebot-tmp2",print_r($event,TRUE)); 
  switch ($event['type']) {
    case 'message':
      $message = $event['message'];
      $source  = $event['source'];
      switch ($message['type']) {
        case 'text':
          $val = trim($message['text']);
          $lnum = find_line($val);
          if ( $lnum > 0 ){
            $text = $data[$lnum][col_response];
          }else{
            $text = $val . " については、すみません、分かりません。";
          }
          // file_put_contents("./temp/linebot-tmp2",print_r($client,TRUE)); 
          text_reply($text, $client, $rtoken);
          break;
        default:
          error_log('Unsupported message type: ' . $message['type']);
          break;
      }
      break;
    default:
      error_log('Unsupported event type: ' . $event['type']);
      break;
  }
}

function find_line($val1){
  global $data;
  //$col_keyword = 0;
  for($i=0; $i<count($data); $i++){
    $pattern = trim( $data[$i][col_keyword] );
    if( preg_match('/('.$pattern.')/', $val1) ){
      return $i;
    }
  }
  return -1;
}

function load_data() {
  $tmp="
場所	アドバイス
お風呂|おふろ|浴室|よくしつ	浴室には、外側から補助錠を取り付け、子どもが勝手に中に入れないようにしましょう。
自転車|じてんしゃ	サイズの大きい服やマフラーは、走行中、車輪などに挟まると大変危険です。なるべく体にフィットした服やスヌードを着けるように工夫しましょう。
";
  // $tmp = file_get_contents(__DIR__ . '/data.tsv');

  $data1 = array();     
  foreach( explode("\n",$tmp) as $line ){
    if ($line != ""){
      $ma = explode("\t",$line);
      $data1[] = $ma;
    }
  }
  return $data1;
}


function text_reply($message1, $client, $reply_token){
  $client->replyMessage([
    'replyToken' => $reply_token,
    'messages' => [
      [
        'type' => 'text',
        'text' => $message1
      ]
    ]
  ]);
}
